Public Class frmMain
    'Define valid month ranges.
    Const intMIN_MONTHS As Integer = 6
    Const intMAX_MONTHS As Integer = 48
    Const sngMONTHS_YEAR As Single = 12.0 ' Months per year

    'Define annual interest rates for new and used cars.
    Const dblNEW_RATE As Double = 0.05  ' Interest rate, new cars
    Const dblUSED_RATE As Double = 0.06 ' Interest rate, used cars

    Dim dblAnnualRate As Double = dblNEW_RATE ' Annual interest rate

    Private Sub btnCalculate_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCalculate.Click
        Try
            ' Calculate and display the loan payment information.
            Dim intCount As Integer  ' Counter for the loop
            Dim intMonths As Integer ' Number of months for the loan
            Dim dblLoan As Double    ' Amount of the loan
            Dim dblPayment As Double ' Monthly payment
            Dim dblInterest As Double  ' Interest paid for the period
            Dim dblPrincipal As Double ' Principal paid for the period

            ' Get the number of months and calculate the loan amount
            intMonths = CInt(txtMonths.Text)
            dblLoan = CDec(txtCost.Text) - CDec(txtDownPayment.Text)

            ' Calculate the monthly payment
            dblPayment = Pmt(dblAnnualRate / sngMONTHS_YEAR, _
                intMonths, -dblLoan)

            ' Clear the list box.
            lstOutput.Items.Clear()

            For intCount = 1 To intMonths
                ' Holds list box output
                Dim strOut As String = String.Empty

                ' Calculate the interest for the period
                dblInterest = IPmt(dblAnnualRate / sngMONTHS_YEAR, _
                    intCount, intMonths, -dblLoan)
                dblPrincipal = PPmt(dblAnnualRate / sngMONTHS_YEAR, _
                    intCount, intMonths, -dblLoan)

                ' Add the month to the output string
                strOut &= "Month: " & intCount.ToString()
                ' Add the payment amount to the output string
                strOut &= "  Payment: " & FormatCurrency(dblPayment)
                ' Add the interest amount to the output string
                strOut &= "  Interest: " & FormatCurrency(dblInterest)
                ' Add the principal for the period
                strOut &= "  Principal: " & FormatCurrency(dblPrincipal)

                ' Add the output string to the list box
                lstOutput.Items.Add(strOut)
            Next intCount
        Catch ex As Exception
            MessageBox.Show(ex.Message, "Error")
        End Try
    End Sub

    Private Sub btnClear_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnClear.Click
        ' Reset the interest rate, clear the text boxes
        ' and clear the list box.
        radNew.Checked = True
        dblAnnualRate = dblNEW_RATE
        lblAnnInt.Text = FormatPercent(dblNEW_RATE)
        txtCost.Clear()
        txtDownPayment.Clear()
        txtMonths.Clear()
        lstOutput.Items.Clear()
        ' Reset the focus
        txtCost.Focus()
    End Sub

    Private Sub btnExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnExit.Click

        ' End the application
        Me.Close()
    End Sub

    Private Sub radNew_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles radNew.CheckedChanged

        ' If the New radio button is checked, then
        ' the user has selected a new car loan.
        If radNew.Checked = True Then
            dblAnnualRate = dblNEW_RATE
            lblAnnInt.Text = FormatPercent(dblNEW_RATE)
        End If
    End Sub

    Private Sub radUsed_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles radUsed.CheckedChanged

        ' User selected the used Car radio button. Set
        ' the interest rate accordingly.
        If radUsed.Checked = True Then
            dblAnnualRate = dblUSED_RATE
            lblAnnInt.Text = FormatPercent(dblUSED_RATE)
        End If
    End Sub

    Private Sub txtCost_Validating(ByVal sender As Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles txtCost.Validating

        ' To handle to error when closing
        If (txtCost.Text = "") Then
            Return
        End If

        ' Validates that a number has been entered into txtCost.
        If Not IsNumeric(txtCost.Text) Then
            MessageBox.Show("Cost must be a number.", "Invalid Vehicle Cost")

            ' Select the existing text in the text box.
            txtCost.SelectAll()

            ' Set e.Cancel to true so the focus will stay
            ' in this control.
            e.Cancel = True
        Else
            e.Cancel = False
        End If
    End Sub

    Private Sub txtDownPayment_Validating(ByVal sender As Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles txtDownPayment.Validating

        ' To handle to error when closing
        If (txtDownPayment.Text = "") Then
            Return
        End If

        ' Validates that a number has been entered into
        ' txtDownPayment.

        If Not IsNumeric(txtDownPayment.Text) Then
            MessageBox.Show("Down payment must be a number.", "Invalid Down Payment")

            ' Select the existing text in the text box
            txtDownPayment.SelectAll()

            ' set e.Cancel to true so the focus will stay
            ' in this control.
            e.Cancel = True
        Else
            e.Cancel = False
        End If
    End Sub

    Private Sub txtMonths_Validating(ByVal sender As Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles txtMonths.Validating

        ' To handle to error when closing
        If (txtMonths.Text = "") Then
            Return
        End If

        ' Validates that months is numeric
        ' and is within a valid range

        If Not IsNumeric(txtMonths.Text) Then
            MessageBox.Show("Months must be a number.", "Error")

            ' Select the existing text in the text box
            txtMonths.SelectAll()

            ' set e.Cancel to true so the focus will stay
            ' in this control.
            e.Cancel = True
        Else
            Dim intMonths As Integer = CInt(txtMonths.Text)

            If intMonths < intMIN_MONTHS Or intMonths > intMAX_MONTHS Then

                MessageBox.Show("Months must be in the range " & intMIN_MONTHS & " - " & intMAX_MONTHS, "Error")

                'Select the existing text in the text box.
                txtMonths.SelectAll()

                ' set e.Cancel to true so the focus will stay
                ' in this control.
                e.Cancel = True
            Else
                e.Cancel = False
            End If
        End If
    End Sub
End Class